'/***
'* mbstring.h - MBCS string manipulation macros and functions
'*
'*       Copyright (c) 1990-1997, Microsoft Corporation.  All rights reserved.
'*
'*Purpose:
'*       This file contains macros and function declarations for the MBCS
'*       string manipulation functions.
'*
'*       [Public]
'*
'****/

#If Not %Def(%MBSTRING_INC)
    %MBSTRING_INC = 1

'typedef unsigned int size_t;

#If Not %Def(%NLSCMP_DEFINED)
%NLSCMP_DEFINED = 1
%NLSCMPERROR   = 2147483647     ' /* currently == INT_MAX */
#EndIf

'typedef char *  va_list;

#If Not %Def(%FILE_DEFINED)
%FILE_DEFINED = 1
Type iobuf
   Ptr      As Asciiz Ptr   ' char *_ptr
   cnt      As Long         ' int   _cnt
   Base     As Asciiz Ptr   ' char *_base
   flag     As Long         ' int   _flag
   file     As Long         ' int   _file
   charbuf  As Long         ' int   _charbuf
   bufsiz   As Long         ' int   _bufsiz
   tmpfname As Asciiz Ptr   ' char *_tmpfname
End Type

'typedef struct _iobuf FILE;
Type FILE
   Ptr      As Asciiz Ptr   ' char *_ptr
   cnt      As Long         ' int   _cnt
   Base     As Asciiz Ptr   ' char *_base
   flag     As Long         ' int   _flag
   file     As Long         ' int   _file
   charbuf  As Long         ' int   _charbuf
   bufsiz   As Long         ' int   _bufsiz
   tmpfname As Asciiz Ptr   ' char *_tmpfname
End Type
#EndIf

'/*
' * MBCS - Multi-Byte Character Set
' */

#If Not %Def(%MBSTRING_DEFINED)
%MBSTRING_DEFINED = 1

'/* function prototypes */

'_CRTIMP unsigned int __cdecl _mbbtombc(unsigned int);
Declare Function mbbtombc CDecl Lib "msvcrt.dll" Alias "_mbbtombc" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Dword                               ' unsigned int

'_CRTIMP int __cdecl _mbbtype(unsigned char, int);
Declare Function mbbtype CDecl Lib "msvcrt.dll" Alias "_mbbtype" ( _
   ByVal Byte, _                            ' unsigned char c
   ByVal Long _                             ' int type
   ) As Long                                ' int

'_CRTIMP unsigned int __cdecl _mbctombb(unsigned int);
Declare Function mbctombb CDecl Lib "msvcrt.dll" Alias "_mbctombb" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Dword                               ' unsigned int

'_CRTIMP int __cdecl _mbsbtype(const unsigned char *, size_t);
Declare Function mbsbtype CDecl Lib "msvcrt.dll" Alias "_mbsbtype" ( _
   ByVal Dword, _                           ' const unsigned char *mbstr
   ByVal Long _                             ' size_t count
   ) As Long                                ' int

'_CRTIMP unsigned char * __cdecl _mbscat(unsigned char *, const unsigned char *);
Declare Function mbscat CDecl Lib "msvcrt.dll" Alias "_mbscat" ( _
   ByVal Dword, _                           ' unsigned char *strDestination
   ByVal Dword _                            ' const unsigned char *strSource
   ) As Dword                               ' unsigned char *

'_CRTIMP unsigned char * __cdecl _mbschr(const unsigned char *, unsigned int);
Declare Function mbschr CDecl Lib "msvcrt.dll" Alias "_mbschr" ( _
   ByVal Dword, _                           ' const unsigned char *str
   ByVal Long _                             ' unsigned int c
   ) As Dword                               ' unsigned char *

'_CRTIMP int __cdecl _mbscmp(const unsigned char *, const unsigned char *);
Declare Function mbscmp CDecl Lib "msvcrt.dll" Alias "_mbscmp" ( _
   ByVal Dword, _                           ' const unsigned char *string1
   ByVal Dword _                            ' const unsigned char *string2
   ) As Long                                ' int

'_CRTIMP int __cdecl _mbscoll(const unsigned char *, const unsigned char *);
Declare Function mbscoll CDecl Lib "msvcrt.dll" Alias "_mbscoll" ( _
   ByVal Dword, _                           ' const unsigned char *string1
   ByVal Dword _                            ' const unsigned char *string2
   ) As Long                                ' int

'_CRTIMP unsigned char * __cdecl _mbscpy(unsigned char *, const unsigned char *);
Declare Function mbscpy CDecl Lib "msvcrt.dll" Alias "_mbscpy" ( _
   ByVal Dword, _                           ' unsigned char (&strDestination)[size]
   ByVal Dword _                            ' const unsigned char *strSource
   ) As Dword                               ' unsigned char *

'_CRTIMP size_t __cdecl _mbscspn(const unsigned char *, const unsigned char *);
Declare Function mbscspn CDecl Lib "msvcrt.dll" Alias "_mbscspn" ( _
   ByVal Dword, _                           ' const unsigned char *str
   ByVal Dword _                            ' const unsigned char *strCharSet
   ) As Dword                               ' size_t

'_CRTIMP unsigned char * __cdecl _mbsdec(const unsigned char *, const unsigned char *);
Declare Function mbsdec CDecl Lib "msvcrt.dll" Alias "_mbsdec" ( _
   ByVal Dword, _                           ' const unsigned char *start
   ByVal Dword _                            ' const unsigned char *current
   ) As Dword                               ' unsigned char *

'_CRTIMP unsigned char * __cdecl _mbsdup(const unsigned char *);
Declare Function mbsdup CDecl Lib "msvcrt.dll" Alias "_mbsdup" ( _
   ByVal Dword _                            ' const unsigned char *strSource
   ) As Dword                               ' char *

'_CRTIMP int __cdecl _mbsicmp(const unsigned char *, const unsigned char *);
Declare Function mbsicmp CDecl Lib "msvcrt.dll" Alias "_mbsicmp" ( _
   ByVal Dword, _                           ' const unsigned char *string1
   ByVal Dword _                            ' const unsigned char *string2
   ) As Long                                ' int

'_CRTIMP int __cdecl _mbsicoll(const unsigned char *, const unsigned char *);
Declare Function mbsicoll CDecl Lib "msvcrt.dll" Alias "_mbsicoll" ( _
   ByVal Dword, _                           ' const unsigned char *string1
   ByVal Dword _                            ' const unsigned char *string2
   ) As Long                                ' int

'_CRTIMP unsigned char * __cdecl _mbsinc(const unsigned char *);
Declare Function mbsinc CDecl Lib "msvcrt.dll" Alias "_mbsinc" ( _
   ByVal Dword _                            ' const unsigned char *current
   ) As Dword                               ' unsigned char *

'_CRTIMP size_t __cdecl _mbslen(const unsigned char *);
Declare Function mbslen CDecl Lib "msvcrt.dll" Alias "_mbslen" ( _
   ByVal Dword _                            ' const unsigned char *str
   ) As Dword                               ' size_t

'_CRTIMP unsigned char * __cdecl _mbslwr(unsigned char *);
Declare Function mbslwr CDecl Lib "msvcrt.dll" Alias "_mbslwr" ( _
   ByVal Dword _                            ' const unsigned char *str
   ) As Dword                               ' unsigned char *

'_CRTIMP unsigned char * __cdecl _mbsnbcat(unsigned char *, const unsigned char *, size_t);
Declare Function mbsnbcat CDecl Lib "msvcrt.dll" Alias "_mbsnbcat" ( _
   ByVal Dword, _                           ' unsigned char (&dest)[size]
   ByVal Dword, _                           ' const unsigned char *src
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' unsigned char *

'_CRTIMP int __cdecl _mbsnbcmp(const unsigned char *, const unsigned char *, size_t);
Declare Function mbsnbcmp CDecl Lib "msvcrt.dll" Alias "_mbsnbcmp" ( _
   ByVal Dword, _                           ' const unsigned char *string1
   ByVal Dword, _                           ' const unsigned char *string2
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int

'_CRTIMP int __cdecl _mbsnbcoll(const unsigned char *, const unsigned char *, size_t);
Declare Function mbsnbcoll CDecl Lib "msvcrt.dll" Alias "_mbsnbcoll" ( _
   ByVal Dword, _                           ' const unsigned char *string1
   ByVal Dword, _                           ' const unsigned char *string2
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int

'_CRTIMP size_t __cdecl _mbsnbcnt(const unsigned char *, size_t);
Declare Function mbsnbcnt CDecl Lib "msvcrt.dll" Alias "_mbsnbcnt" ( _
   ByVal Dword, _                           ' const unsigned char *string
   ByVal Dword _                            ' size_t number
   ) As Dword                               ' size_t

'_CRTIMP unsigned char * __cdecl _mbsnbcpy(unsigned char *, const unsigned char *, size_t);
Declare Function mbsnbcpy CDecl Lib "msvcrt.dll" Alias "_mbsnbcpy" ( _
   ByVal Dword, _                           ' unsigned char * strDest
   ByVal Dword, _                           ' const unsigned char * strSource
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' unsigned char *

'_CRTIMP int __cdecl _mbsnbicmp(const unsigned char *, const unsigned char *, size_t);
Declare Function mbsnbicmp CDecl Lib "msvcrt.dll" Alias "_mbsnbicmp" ( _
   ByVal Dword, _                           ' const unsigned char *string1
   ByVal Dword, _                           ' const unsigned char *string2
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int

'_CRTIMP int __cdecl _mbsnbicoll(const unsigned char *, const unsigned char *, size_t);
Declare Function mbsnbicoll CDecl Lib "msvcrt.dll" Alias "_mbsnbicoll" ( _
   ByVal Dword, _                           ' const unsigned char *string1
   ByVal Dword, _                           ' const unsigned char *string2
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int

'_CRTIMP unsigned char * __cdecl _mbsnbset(unsigned char *, unsigned int, size_t);
Declare Function mbsnbset CDecl Lib "msvcrt.dll" Alias "_mbsnbset" ( _
   ByVal Dword, _                           ' unsigned char *str
   ByVal Dword, _                           ' unsigned int c
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' unsigned char *

'_CRTIMP unsigned char * __cdecl _mbsncat(unsigned char *, const unsigned char *, size_t);
Declare Function mbsncat CDecl Lib "msvcrt.dll" Alias "_mbsncat" ( _
   ByVal Dword, _                           ' unsigned char *strDest
   ByVal Dword, _                           ' const unsigned char *strSource
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' unsigned char *

'_CRTIMP size_t __cdecl _mbsnccnt(const unsigned char *, size_t);
Declare Function mbsnccnt CDecl Lib "msvcrt.dll" Alias "_mbsnccnt" ( _
   ByVal Dword, _                           ' const unsigned char *string
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' size_t

'_CRTIMP int __cdecl _mbsncmp(const unsigned char *, const unsigned char *, size_t);
Declare Function mbsncmp CDecl Lib "msvcrt.dll" Alias "_mbsncmp" ( _
   ByVal Dword, _                           ' const unsigned char *string1
   ByVal Dword, _                           ' const unsigned char *string2
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int

'_CRTIMP int __cdecl _mbsncoll(const unsigned char *, const unsigned char *, size_t);
Declare Function mbsncoll CDecl Lib "msvcrt.dll" Alias "_mbsncoll" ( _
   ByVal Dword, _                           ' const unsigned char *string1
   ByVal Dword, _                           ' const unsigned char *string2
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int

'_CRTIMP unsigned char * __cdecl _mbsncpy(unsigned char *, const unsigned char *, size_t);
Declare Function mbsncpy CDecl Lib "msvcrt.dll" Alias "_mbsncpy" ( _
   ByVal Dword, _                           ' unsigned char *strDest
   ByVal Dword, _                           ' const unsigned char *strSource
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' unsigned char *

'_CRTIMP unsigned int __cdecl _mbsnextc (const unsigned char *);
Declare Function mbsnextc CDecl Lib "msvcrt.dll" Alias "_mbsnextc" ( _
   ByVal Dword _                            ' const unsigned char *string
   ) As Dword                               ' unsigned int

'_CRTIMP int __cdecl _mbsnicmp(const unsigned char *, const unsigned char *, size_t);
Declare Function mbsnicmp CDecl Lib "msvcrt.dll" Alias "_mbsnicmp" ( _
   ByVal Dword, _                           ' const unsigned char *string1
   ByVal Dword, _                           ' const unsigned char *string2
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int

'_CRTIMP int __cdecl _mbsnicoll(const unsigned char *, const unsigned char *, size_t);
Declare Function mbsnicoll CDecl Lib "msvcrt.dll" Alias "_mbsnicoll" ( _
   ByVal Dword, _                           ' const unsigned char *string1
   ByVal Dword, _                           ' const unsigned char *string2
   ByVal Dword _                            ' size_t count
   ) As Long                                ' int

'_CRTIMP unsigned char * __cdecl _mbsninc(const unsigned char *, size_t);
Declare Function mbsninc CDecl Lib "msvcrt.dll" Alias "_mbsninc" ( _
   ByVal Dword, _                           ' const unsigned char *string
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' unsigned char *

'_CRTIMP unsigned char * __cdecl _mbsnset(unsigned char *, unsigned int, size_t);
Declare Function mbsnset CDecl Lib "msvcrt.dll" Alias "_mbsnset" ( _
   ByVal Dword, _                           ' const unsigned char *string
   ByVal Dword, _                           ' unsigned int c
   ByVal Dword _                            ' size_t count
   ) As Dword                               ' unsigned char *

'_CRTIMP unsigned char * __cdecl _mbspbrk(const unsigned char *, const unsigned char *);
Declare Function mbspbrk CDecl Lib "msvcrt.dll" Alias "_mbspbrk" ( _
   ByVal Dword, _                           ' const unsigned char *str
   ByVal Dword _                            ' const unsigned char *strCharSet
   ) As Dword                               ' unsigned char *

'_CRTIMP unsigned char * __cdecl _mbsrchr(const unsigned char *, unsigned int);
Declare Function mbsrchr CDecl Lib "msvcrt.dll" Alias "_mbsrchr" ( _
   ByVal Dword, _                           ' const unsigned char *str
   ByVal Dword _                            ' unsigned int c
   ) As Dword                               ' unsigned char *

'_CRTIMP unsigned char * __cdecl _mbsrev(unsigned char *);
Declare Function mbsrev CDecl Lib "msvcrt.dll" Alias "_mbsrev" ( _
   ByVal Dword _                            ' const unsigned char *str
   ) As Dword                               ' unsigned char *

'_CRTIMP unsigned char * __cdecl _mbsset(unsigned char *, unsigned int);
Declare Function mbsset CDecl Lib "msvcrt.dll" Alias "_mbsset" ( _
   ByVal Dword, _                           ' unsigned char *string
   ByVal Dword _                            ' unsigned int c
   ) As Dword                               ' unsigned char *

'_CRTIMP size_t __cdecl _mbsspn(const unsigned char *, const unsigned char *);
Declare Function mbsspn CDecl Lib "msvcrt.dll" Alias "_mbsspn" ( _
   ByVal Dword, _                           ' unsigned char *string
   ByVal Dword _                            ' const unsigned char *strCharSet
   ) As Dword                               ' size_t

'_CRTIMP unsigned char * __cdecl _mbsspnp(const unsigned char *, const unsigned char *);
Declare Function mbsspnp CDecl Lib "msvcrt.dll" Alias "_mbsspnp" ( _
   ByVal Dword, _                           ' const unsigned char *string1
   ByVal Dword _                            ' const unsigned char *string2
   ) As Dword                               ' unsigned char *

'_CRTIMP unsigned char * __cdecl _mbsstr(const unsigned char *, const unsigned char *);
Declare Function mbsstr CDecl Lib "msvcrt.dll" Alias "_mbsstr" ( _
   ByVal Dword, _                           ' const unsigned char *str
   ByVal Dword _                            ' const unsigned char *strSearch
   ) As Dword                               ' unsigned char *

'_CRTIMP unsigned char * __cdecl _mbstok(unsigned char *, const unsigned char *);
Declare Function mbstok CDecl Lib "msvcrt.dll" Alias "_mbstok" ( _
   ByVal Dword, _                           ' unsigned char *strToken
   ByVal Dword _                            ' const unsigned char *strDelimit
   ) As Dword                               ' unsigned char *

'_CRTIMP unsigned char * __cdecl _mbsupr(unsigned char *);
Declare Function mbsupr CDecl Lib "msvcrt.dll" Alias "_mbsupr" ( _
   ByVal Dword _                            ' unsigned char *str
   ) As Dword                               ' unsigned char *

'_CRTIMP size_t __cdecl _mbclen(const unsigned char *);
Declare Function mbclen CDecl Lib "msvcrt.dll" Alias "_mbclen" ( _
   ByVal Dword _                            ' const unsigned char *mbstr
   ) As Dword                               ' size_t

'_CRTIMP void __cdecl _mbccpy(unsigned char *, const unsigned char *);
Declare Sub mbccpy CDecl Lib "msvcrt.dll" Alias "_mbccpy" ( _
   ByVal Dword, _                           ' unsigned char *dest
   ByVal Dword _                            ' const unsigned char *src
   )                                        ' void

'#define _mbccmp(_cpc1, _cpc2) _mbsncmp((_cpc1),(_cpc2),1)
Macro mbccmp(cpc1, cpc2) = mbsncmp(cpc1, cpc2, 1)

''/* character routines */

'_CRTIMP int __cdecl _ismbcalnum(unsigned int);
Declare Function ismbcalnum CDecl Lib "msvcrt.dll" Alias "_ismbcalnum" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbcalpha(unsigned int);
Declare Function ismbcalpha CDecl Lib "msvcrt.dll" Alias "_ismbcalpha" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbcdigit(unsigned int);
Declare Function ismbcdigit CDecl Lib "msvcrt.dll" Alias "_ismbcdigit" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbcgraph(unsigned int);
Declare Function ismbcgraph CDecl Lib "msvcrt.dll" Alias "_ismbcgraph" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbclegal(unsigned int);
Declare Function ismbclegal CDecl Lib "msvcrt.dll" Alias "_ismbclegal" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbclower(unsigned int);
Declare Function ismbclower CDecl Lib "msvcrt.dll" Alias "_ismbclower" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbcprint(unsigned int);
Declare Function ismbcprint CDecl Lib "msvcrt.dll" Alias "_ismbcprint" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbcpunct(unsigned int);
Declare Function ismbcpunct CDecl Lib "msvcrt.dll" Alias "_ismbcpunct" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbcspace(unsigned int);
Declare Function ismbcspace CDecl Lib "msvcrt.dll" Alias "_ismbcspace" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbcupper(unsigned int);
Declare Function ismbcupper CDecl Lib "msvcrt.dll" Alias "_ismbcupper" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP unsigned int __cdecl _mbctolower(unsigned int);
Declare Function mbctolower CDecl Lib "msvcrt.dll" Alias "_mbctolower" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Dword                               ' unsigned int

'_CRTIMP unsigned int __cdecl _mbctoupper(unsigned int);
Declare Function mbctoupper CDecl Lib "msvcrt.dll" Alias "_mbctoupper" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Dword                               ' unsigned int

#EndIf   ' #IF NOT %DEF(%MBSTRING_DEFINED)


#If Not %Def(%MBLEADTRAIL_DEFINED)
%MBLEADTRAIL_DEFINED = 1

'_CRTIMP int __cdecl _ismbblead( unsigned int );
Declare Function ismbblead CDecl Lib "msvcrt.dll" Alias "_ismbblead" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbbtrail( unsigned int );
Declare Function ismbbtrail CDecl Lib "msvcrt.dll" Alias "_ismbbtrail" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbslead( const unsigned char *, const unsigned char *);
Declare Function ismbslead CDecl Lib "msvcrt.dll" Alias "_ismbslead" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbstrail( const unsigned char *, const unsigned char *);
Declare Function ismbstrail CDecl Lib "msvcrt.dll" Alias "_ismbstrail" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

#EndIf   ' #IF NOT %DEF(%MBLEADTRAIL_DEFINED)

'/*  Kanji specific prototypes.  */

'_CRTIMP int __cdecl _ismbchira(unsigned int);
Declare Function ismbchira CDecl Lib "msvcrt.dll" Alias "_ismbchira" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbckata(unsigned int);
Declare Function ismbckata CDecl Lib "msvcrt.dll" Alias "_ismbckata" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbcsymbol(unsigned int);
Declare Function ismbcsymbol CDecl Lib "msvcrt.dll" Alias "_ismbcsymbol" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbcl0(unsigned int);
Declare Function ismbcl0 CDecl Lib "msvcrt.dll" Alias "_ismbcl0" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbcl1(unsigned int);
Declare Function ismbcl1 CDecl Lib "msvcrt.dll" Alias "_ismbcl1" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP int __cdecl _ismbcl2(unsigned int);
Declare Function ismbcl2 CDecl Lib "msvcrt.dll" Alias "_ismbcl2" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Long                                ' int

'_CRTIMP unsigned int __cdecl _mbcjistojms(unsigned int);
Declare Function mbcjistojms CDecl Lib "msvcrt.dll" Alias "_mbcjistojms" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Dword                               ' unsigned int

'_CRTIMP unsigned int __cdecl _mbcjmstojis(unsigned int);
Declare Function mbcjmstojis CDecl Lib "msvcrt.dll" Alias "_mbcjmstojis" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Dword                               ' unsigned int

'_CRTIMP unsigned int __cdecl _mbctohira(unsigned int);
Declare Function mbctohira CDecl Lib "msvcrt.dll" Alias "_mbctohira" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Dword                               ' unsigned int

'_CRTIMP unsigned int __cdecl _mbctokata(unsigned int);
Declare Function mbctokata CDecl Lib "msvcrt.dll" Alias "_mbctokata" ( _
   ByVal Dword _                            ' unsigned int c
   ) As Dword                               ' unsigned int

#EndIf   ' #IF NOT %DEF(%MBSTRING_INC)